<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v1.2
|   ========================================
|   by Matthew Mecham
|   (c) 2001 - 2003 Invision Power Services
|   http://www.invisionpower.com
|   ========================================
|   Web: http://www.invisionboard.com
|   Email: matt@invisionpower.com
|   Licence Info: http://www.invisionboard.com/?license
+---------------------------------------------------------------------------
|
|   > Admin Setting functions
|   > Module written by Matt Mecham
|   > Date started: 20th March 2002
|
|	> Module Version Number: 1.0.0
+--------------------------------------------------------------------------
*/


$idx = new ad_settings();


class ad_settings {

	var $base_url;

	function ad_settings() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		//---------------------------------------
		// Kill globals - globals bad, Homer good.
		//---------------------------------------
		
		$tmp_in = array_merge( $_GET, $_POST, $_COOKIE );
		
		foreach ( $tmp_in as $k => $v )
		{
			unset($$k);
		}

		//---------------------------------------
		
		$DB->query("SELECT VERSION() AS version");
		
		if ( ! $row = $DB->fetch_row() )
		{
			$DB->query("SHOW VARIABLES LIKE 'version'");
			$row = $DB->fetch_row();
		}
		
		$this->true_version = $row['version'];
		
		$no_array = explode( '.', preg_replace( "/^(.+?)[-_]?/", "\\1", $row['version']) );
		
		$one   = (!isset($no_array) || !isset($no_array[0])) ? 3  : $no_array[0];
		$two   = (!isset($no_array[1]))                      ? 21 : $no_array[1];
		$three = (!isset($no_array[2]))                      ? 0  : $no_array[2];
		
   		$this->mysql_version = (int)sprintf('%d%02d%02d', $one, $two, intval($three));

		switch($IN['code'])
		{
			case 'fulltext':
				$this->fulltext();
				break;
				
			case 'dofulltext':
				$this->do_fulltext();
				break;
				
			case 'phpinfo':
				phpinfo();
				exit;
				
			case 'glines':
				$this->guidelines();
				break;
			case 'doglines':
				$this->do_guidelines();
				break;
				
			case 'cookie':
				$this->cookie();
				break;
			case 'docookie':
				$this->save_config( array( 'cookie_domain', 'cookie_id', 'cookie_path' ) );
				break;
				
			case 'warn':
				$this->warn();
				break;
			case 'dowarn':
				$HTTP_POST_VARS['warn_protected'] = ','. @implode( ",", $HTTP_POST_VARS['groups'] ) . ',';
				$this->save_config( array( 	'warn_show_rating', "warn_past_max", 'warn_show_own', 'warn_min', 'warn_protected', 'warn_mod_day', 'warn_gmod_day', "warn_gmod_ban","warn_gmod_modq","warn_gmod_post","warn_mod_post","warn_mod_modq","warn_mod_ban",'warn_max',"warn_on" ) );
				break;

			case 'secure':
				$this->secure();
				break;
			case 'dosecure':
				$this->save_config( array ( 'strip_space_chr', 'validate_day_prune', 'bot_antispam', 'use_ttf', 'gd_width', 'gd_height',"gd_font",  'disable_admin_anon', 'disable_online_ip', 'disable_reportpost', 'allow_dynamic_img','session_expiration','match_browser','allow_dup_email','allow_images', 'force_login', 'no_reg',
											'allow_flash','new_reg_notify','use_mail_form','flood_control', 'allow_online_list', 'reg_auth_type' ) );
				break;
			//-------------------------
			case 'post':
				$this->post();
				break;
			case 'dopost':
//-- mod_resize_images begin ͼ
                global $mod_rsi;
                $mod_rsi->save_config();
        
                if (isset($IN['poll_tags'] )) 
//-- mod_resize_images end ͼ


				$this->save_config( array ( 'poll_disable_noreply', 'siu_thumb', 'siu_width', 'siu_height', 'startpoll_cutoff', 'post_wordwrap', 'allow_result_view', 'max_poll_choices', 'poll_tags', 'guest_name_pre', 'guest_name_suf', 'max_w_flash', 'max_h_flash', 'hot_topic', 'display_max_topics','display_max_posts','max_emos','max_images','emo_per_row', 'etfilter_punct', 'etfilter_shout',
											'strip_quotes', 'max_post_length','show_img_upload','pre_polls','pre_moved','pre_pinned','img_ext' ) );
				break;
			//-------------------------
			case 'avatars':
				$this->avatars();
				break;
			case 'doavatars':
				$this->save_config( array ( 'av_gal_cols' , "disable_ipbsize", "photo_ext", 'subs_autoprune', 'topicpage_contents', 'postpage_contents', 'allow_skins', 'max_sig_length', 'sig_allow_ibc', 'sig_allow_html','avatar_ext','avatar_url','avup_size_max','avatars_on','avatar_dims','avatar_def', 'max_location_length', 'max_interest_length', 'post_titlechange', 'guests_ava', 'guests_img', 'guests_sig' ) );
				break;
			//-------------------------
			case 'dates':
				$this->dates();
				break;
			case 'dodates':
				$this->save_config( array ( 'time_offset','clock_short','clock_joined','clock_long', 'time_adjust' ) );
				break;
			//-------------------------
			
			case 'calendar':
				$this->calendar();
				break;
			case 'docalendar':
				$this->save_config( array ( 'autohide_bday', 'autohide_calendar', 'show_birthdays', 'show_bday_calendar', 'show_calendar','calendar_limit', 'year_limit', 'start_year' ) );
				break;
			//-------------------------
                        //Ǯhack
			case 'money':
				$this->money();
				break;
			case 'domoney':
				$this->save_config( array ( 'enable_money_system', 'interest_per_day', 'money_register', 'money_per_topic', 'money_per_post', 'money_per_poll', 'money_per_vote', 'money_per_kernel', 'money_per_delete','money_view_step', 'money_view_bounty', 'money_view_count_self', 'money_reply_step', 'money_reply_bounty', 'money_reply_count_self' ) );
				break;
			//-------------------------
			
			case 'cpu':
				$this->cpu();
				break;
			case 'docpu':
				$this->save_config( array ( 'custom_profile_topic', 'min_search_word', 'short_forum_jump', 'no_au_forum', 'no_au_topic', 'au_cutoff', 'load_limit','show_active','show_birthdays','show_totals','allow_search', 'search_post_cut', 'show_user_posted', 'nocache' ) );
				break;
			//-------------------------
			case 'email':
				$this->email();
				break;
			case 'doemail':
				$this->save_config( array ( 'email_in', 'email_out', 'mail_method', 'smtp_host', 'smtp_port', 'smtp_user', 'smtp_pass' ) );
				break;
			//-------------------------
			case 'url':
				$this->url();
				break;
			case 'dourl':
				$this->save_config( array ( 'number_format', 'html_dir','safe_mode_skins', 'board_name','board_url','home_name','home_url', 'disable_gzip',
										    'html_url','upload_url', 'upload_dir', 'print_headers', 'header_redirect', 'debug_level', 'sql_debug', 'auto_pm_on', 'auto_pm_subject', 'auto_pm_message', 'auto_pm_from') );
				break;
				break;
			//-------------------------
			case 'pm':
				$this->pm();
				break;
			case 'dopm':
				$this->save_config( array ( 'show_max_msg_list', 'msg_allow_code', 'msg_allow_html' ) );
				break;
			//-------------------------
			case 'news':
				$this->news();
				break;
			case 'donews':
				$this->save_config( array ( 'news_forum_id', 'index_news_link' ) );
				break;
			//-------------------------
			case 'coppa':
				$this->coppa();
				break;
			case 'docoppa':
				$this->save_config( array ( 'use_coppa', 'coppa_fax', 'coppa_address' ) );
				break;
			//-------------------------
			case 'board':
				$this->board();
				break;
			case 'doboard':
				$this->save_config( array ( 'board_offline', 'offline_msg' ) );
				break;
			//-------------------------
			case 'spider':
				$this->spider();
				break;
			case 'dospider':
				$this->save_config( array (  'spider_suit', "spider_sense","spider_visit","spider_group","spider_active",'sp_google' ,'sp_inktomi','sp_lycos'  ,'sp_jeeves','sp_wuseek', 'spider_anon' ) );
				break;
			//-------------------------
			case 'bw':
				$this->badword();
				break;
			case 'bw_add':
				$this->add_badword();
				break;
			case 'bw_remove':
				$this->remove_badword();
				break;
			case 'bw_edit':
				$this->edit_badword();
				break;
			case 'bw_doedit':
				$this->doedit_badword();
				break;
			//-------------------------
			case 'emo':
				$this->emoticons();
				break;
			case 'emo_add':
				$this->add_emoticons();
				break;
			case 'emo_remove':
				$this->remove_emoticons();
				break;
			case 'emo_edit':
				$this->edit_emoticons();
				break;
			case 'emo_doedit':
				$this->doedit_emoticons();
				break;
			case 'emo_upload':
				$this->upload_emoticon();			
			//-------------------------
			case 'count':
				$this->countstats();
				break;
			case 'docount':
				$this->docount();
				break;
			default:
				$this->cookie();
				break;
		}
		
	}
	
	
	
	//-------------------------------------------------------------
	// Full Text options page
	//--------------------------------------------------------------
	
	function fulltext()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
	
		//---------------------------------------
		// Get the mySQL version.
		// Adapted from phpMyAdmin
		//---------------------------------------
		
		$DB->query("SELECT VERSION() AS version");
		
		if ( ! $row = $DB->fetch_row() )
		{
			$DB->query("SHOW VARIABLES LIKE 'version'");
			$row = $DB->fetch_row();
		}
		
		$this->true_version = $row['version'];
		
		$no_array = explode( '.', preg_replace( "/^(.+?)[-_]?/", "\\1", $row['version']) );
		
		$one   = (!isset($no_array) || !isset($no_array[0])) ? 3  : $no_array[0];
		$two   = (!isset($no_array[1]))                      ? 21 : $no_array[1];
		$three = (!isset($no_array[2]))                      ? 0  : $no_array[2];
		
   		$this->mysql_version = (int)sprintf('%d%02d%02d', $one, $two, intval($three));
   		
   		$this->common_header('dofulltext', 'ȫļ趨', '̬');
   		
   		if ( $this->mysql_version < 32323 )
   		{
   			$ADMIN->html .= $SKIN->add_td_basic("<strong>Ǹװ MySQL ûʹȫļ</strong><br />̽ MySQL ");
											
   			$ADMIN->html .= $SKIN->end_form($button);
										 
			$ADMIN->html .= $SKIN->end_table();
		
			$ADMIN->output();
			
			exit();
		}
		else
		{
			$ADMIN->html .= $SKIN->add_td_basic("<strong>ʲôȫļ</strong><br />ȫļһά˹
												ܷǳЧʵµķʽ");
												
			//-------------------------------------------
			// Do we already have full text enabled?
			//-------------------------------------------
			
			$DB->query("SHOW CREATE TABLE ibf_posts");
			
			$tbl_info = $DB->fetch_row();
			
			if ( preg_match( "/FULLTEXT KEY/i", $tbl_info['Create Table'] ) )
			{
				$ADMIN->html .= $SKIN->add_td_basic("<b>ȫѾ</b><input type='hidden' name='ftexist' value='1' />");
									 			 
				$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ҫʹõͣ</b>" ,
												  $SKIN->form_dropdown( "search_sql_method", array( 0 => array( 'ftext', 'ȫ' ), 1 => array( 'man', 'ֶ' ) ), $INFO['search_sql_method'] )
										 )      );
	
				$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ԥģʽ</b><br>ֻʹȫļʱӰ" ,
												  $SKIN->form_dropdown( "search_default_method", array( 0 => array( 'simple', '' ), 1 => array( 'adv', '' ) ), $INFO['search_default_method']  )
										 )      );
			}
			else
			{
				$ADMIN->html .= $SKIN->add_td_basic( "<b>Խ趨֮ǰ뽨ȫֻҪͳ˱ɿʼ</b>" .
											       "<input type='hidden' name='setup' value='1'>");
			}
			
			$this->common_footer();
		}						 
	}
	
	//-------------------------------------------------------------
	// Save full text options
	//--------------------------------------------------------------
	
	function do_fulltext()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ( $IN['ftexist'] == 1)
		{
			$master = array();
			$master['search_sql_method']      = $IN['search_sql_method'];
			$master['search_default_method']  = $IN['search_default_method'];
			
			$ADMIN->rebuild_config($master);
		}
		else
		{
			// They don't.
			// Check for correct version and if need be, attempt to create the indexes...
			
			if ( $this->mysql_version >= 32323 )
			{
				// How many posts do we have?
				
				$DB->query("SELECT COUNT(*) as cnt from ibf_posts");
				
				$result = $DB->fetch_row();
				
				// If over 15,000 posts...
				
				if ( $result['cnt'] > 15000 )
				{
					// Explain how, why and what to do..
					
					$ADMIN->page_detail = "";
					$ADMIN->page_title  = "޷";
		
					$ADMIN->html .= $SKIN->add_td_basic( $this->return_sql_no_no_cant_do_it_sorry_text(), 'left', 'faker' );
					
					$ADMIN->output();
				}
				else
				{
					// Index away!
					
					$DB->query("alter table ibf_topics add fulltext(title)");
					
					$DB->query("alter table ibf_posts add fulltext(post)");
					
				}
			}
			else
			{
				$ADMIN->error("ǸĿǰ MySQL 汾޷ʹȫļ");
			}
		}
		
		$ADMIN->save_log("Ѹȫѡ");
		
		$ADMIN->done_screen("Ѹȫ趨", "ȫ趨", "act=op&code=fulltext" );
		
	}
	
	//-------------------------------------------------------------
	// WARNY PORNY!
	//--------------------------------------------------------------
	
	function warn()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dowarn', 'Ա趨', '̬' );
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups ORDER BY g_title");
		
		while ( $r = $DB->fetch_row() )
		{
			$mem_group[] = array( $r['g_id'] , $r['g_title'] );
		}
		
		$protected = explode(',', trim($INFO['warn_protected']) );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>þϵͳ</b>" ,
										  $SKIN->form_yes_no( "warn_on", $INFO['warn_on']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>㼶...</b><br />ԱеӾָй" ,
										 'С '.$SKIN->form_simple_input( 'warn_min' , $INFO['warn_min']  == "" ? 0 : $INFO['warn_min'] ) .'  '.
										 ' '.$SKIN->form_simple_input( 'warn_max' , $INFO['warn_max']  == "" ? 10 : $INFO['warn_max'] ) .
										 "<br>ʹøǽҪʹͼη鼰ٷֱȣ '' ģʽΪ 'ģʽ' ùǵʼΪ<br>Աעʱ㼶Ǵ㿪ʼ"
								 )      );	
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ܱȺ...</b><br>޷Ⱥ<br />ѡһ" ,
												  $SKIN->form_multiselect( "groups[]", $mem_group, $protected )
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>вܱȺ鿴 <em>Լ</em> ľ㼶ɣ</b>" ,
										  $SKIN->form_yes_no( "warn_show_own", $INFO['warn_show_own']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>һﵽСֵʱ棿</b>" ,
										  $SKIN->form_yes_no( "warn_past_max", $INFO['warn_past_max']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ӿָͣ</b>" ,
										  $SKIN->form_dropdown( 'warn_show_rating', array( 0 => array( 0, 'ģʽʾͼη & ٷֱ' ), 1 => array( 1, 'ģʽʾ < С | Ŀǰ |  > 㼶' ) ), $INFO['warn_show_rating']  )
								 )      );				 
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'Ȩ', 'left', 'catrow2' );
		
		//----------------------------------------------------------------------------------------------------------- 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɾƽ̨</b><br />Щʹþϵͳİ<br />Աɾƽ̨ԶΪ֮" ,
										  $SKIN->form_yes_no( "warn_mod_ban", $INFO['warn_mod_ban']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɾƽ̨лԱ</b><br />Щʹþϵͳİ<br />Աɾƽ̨ԶΪ֮" ,
										  $SKIN->form_yes_no( "warn_mod_modq", $INFO['warn_mod_modq']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɾƽ̨ƳȨ</b><br />Щʹþϵͳİ<br />Աɾƽ̨ԶΪ֮" ,
										  $SKIN->form_yes_no( "warn_mod_post", $INFO['warn_mod_post']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԾԱ...</b>" ,
										 $SKIN->form_input( 'warn_mod_day' , $INFO['warn_mod_day']  == "" ? 1 : $INFO['warn_mod_day'] ).'... һ'
								 )      );		
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ȫȨ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ȫɾƽ̨</b><br />Աɾƽ̨ԶΪ֮" ,
										  $SKIN->form_yes_no( "warn_gmod_ban", $INFO['warn_gmod_ban']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ȫɾƽ̨лԱ</b><br />Աɾƽ̨ԶΪ֮" ,
										  $SKIN->form_yes_no( "warn_gmod_modq", $INFO['warn_gmod_modq']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ȫɾƽ̨ƳȨ</b><br />Աɾƽ̨ԶΪ֮" ,
										  $SKIN->form_yes_no( "warn_gmod_post", $INFO['warn_gmod_post']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ȫԾԱ...</b>" ,
										 $SKIN->form_input( 'warn_gmod_day' , $INFO['warn_gmod_day']  == "" ? 1 : $INFO['warn_gmod_day'] ).'... һ'
								 )      );
								 
		$this->common_footer();
	
	}
	
	//-------------------------------------------------------------
	// SPIDER MAN! CHECK OUT THOSE CRAZY PANTS!
	//--------------------------------------------------------------
	
	function spider()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dospider', '֩/趨', '̬<br />'.$SKIN->js_help_link('set_spider') );
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups ORDER BY g_title");
		
		$mem_group = array();
		
		while ( $r = $DB->fetch_row() )
		{
			if ($INFO['admin_group'] == $r['g_id'])
			{
				if ($MEMBER['mgroup'] != $INFO['admin_group'])
				{
					continue;
				}
			}
			
			$mem_group[] = array( $r['g_id'] , $r['g_title'] );
		}
		
		$DB->query("SELECT sname, sid FROM ibf_skins ORDER BY sname");
		
		$skin_sets = array( 0 => array('', "ʹԤ" ) );
		
		while ( $s = $DB->fetch_row() )
		{
			$skin_sets[] = array( $s['sid'], $s['sname'] );
		}
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>֩ʶ</b>" ,
										  $SKIN->form_yes_no( "spider_sense", $INFO['spider_sense']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>¼֩ʣ</b><br />⵽ضȹرգ" ,
										  $SKIN->form_yes_no( "spider_visit", $INFO['spider_visit']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>֩/˵ĸȺһݣ</b>" ,
										  $SKIN->form_dropdown( "spider_group", $mem_group, $INFO['spider_group'] == "" ? $INFO['guest_group'] : $INFO['spider_group']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ǿ֩/ʹ壺</b>" ,
										  $SKIN->form_dropdown( "spider_suit", $skin_sets, $INFO['spider_suit']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ڻʹбʾ֩/ˣ</b>" ,
										  $SKIN->form_yes_no( "spider_active", $INFO['spider_active']  )
										  ."<br />".$SKIN->form_checkbox( 'spider_anon', $INFO['spider_anon'] )." ʾΪ (ֻ߹ԱԿ)"
								 )      );
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ڻʹб...', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> Googlebot...</b>" ,
										 $SKIN->form_input( 'sp_google' , $INFO['sp_google']  == "" ? 'GoogleBot'   : $INFO['sp_google'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> Microsoft / Hotbot...</b>" ,
										 $SKIN->form_input( 'sp_inktomi', $INFO['sp_inktomi'] == "" ? 'Hot Bot'     : $INFO['sp_inktomi'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> Lycos...</b>" ,
										 $SKIN->form_input( 'sp_lycos'  , $INFO['sp_lycos']   == "" ? 'Lycos'       : $INFO['sp_lycos'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> Ask Jeeves...</b>" ,
										 $SKIN->form_input( 'sp_jeeves' , $INFO['sp_jeeves']  == "" ? 'Ask Jeeves'  : $INFO['sp_jeeves'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> What U Seek...</b>" ,
										 $SKIN->form_input( 'sp_wuseek' , $INFO['sp_wuseek']  == "" ? 'What U Seek' : $INFO['sp_wuseek'] )
								 )      );
		
		$this->common_footer();
	
	
	}
	
	
	//-------------------------------------------------------------
	// Board Guidelines
	//--------------------------------------------------------------
	
	function do_guidelines()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$master = array();
		$master['gl_show']  = $IN['gl_show'];
		$master['gl_link']  = $IN['gl_link'];
		$master['gl_title'] = $DB->oopsAddSlashes($IN['gl_title']); /*  */
		
		$ADMIN->rebuild_config($master);
		
		$glines = $std->txt_raw2form($HTTP_POST_VARS['gl_guidelines']);
		$glines = str_replace( "<br>", "<br />", $glines);
		
		$DB->query("SELECT * FROM ibf_cache_store WHERE cs_key='boardrules'");

		if ( $row = $DB->fetch_row() )
		{
			$DB->query("UPDATE ibf_cache_store SET cs_value='".$DB->oopsAddSlashes($glines)."' WHERE cs_key='boardrules'");
		}
		else
		{
			$db_string = $DB->compile_db_insert_string( array(
															   'cs_key' => 'boardrules',
															   'cs_value' => $glines,
										  ) );

			$DB->query("INSERT INTO ibf_cache_store (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
		}

		$ADMIN->save_log("Ѹָ̳");
		
		$ADMIN->done_screen("Ѹ̬", "̨ҳ", "act=index" );
		
	}
	
	//---------------------------------------------
	
	function guidelines()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('doglines', '̳׼/', '̬');
		
		$DB->query("SELECT * FROM ibf_cache_store WHERE cs_key='boardrules'");
		
		$row = $DB->fetch_row();
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ҳüʾ׼᣿</b>" ,
										  $SKIN->form_yes_no( "gl_show", $INFO['gl_show'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ⲿ׼ҳ http:// ᣿</b><br>ʹڲҳ" ,
										  $SKIN->form_input( "gl_link", $INFO['gl_link'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹҳüϵ̧ͷ</b>" ,
										  $SKIN->form_input( "gl_title", $INFO['gl_title'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹⲿ᣻׼/</b><br>HTML " ,
										  $SKIN->form_textarea( "gl_guidelines", $std->my_br2nl($row['cs_value']), 65, 20  )
								 )      );
								 
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// COPPA
	//--------------------------------------------------------------
	
	function coppa()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docoppa', 'COPPA 趨', 'áע⣬̳ <a href="http://www.ftc.gov/ogc/coppa1.htm" target="_blank">COPPA</a> ʱҪ 13 µĶͯԴʼȡøĸͬ⡣');
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ COPPA עϵͳ</b>" ,
										  $SKIN->form_yes_no( "use_coppa", $INFO['use_coppa']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> COPPA Ĵ</b>" ,
										  $SKIN->form_input( "coppa_fax", $INFO['coppa_fax']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> COPPA ʼַ</b>" ,
										  $SKIN->form_textarea( "coppa_address", str_replace( "\n\n", "\n", $std->my_br2nl(str_replace( "\r\n", "\n", $INFO['coppa_address']) ) )  )
								 )      );
		
		
		$this->common_footer();
	
	
	}
	
	//=====================================================
	
	function docount()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ( (! $IN['posts']) and (! $IN['members'] ) and (! $IN['lastreg'] ) )
		{
			$ADMIN->error("ûҪ¼ģ");
		}
		
		$stats = array();
		
		if ($IN['posts'])
		{
			$DB->query("SELECT COUNT(pid) as posts FROM ibf_posts WHERE queued <> 1");
			$r = $DB->fetch_row();
			$stats['TOTAL_REPLIES'] = $r['posts'];
			$stats['TOTAL_REPLIES'] < 1 ? 0 : $stats['TOTAL_REPLIES'];
			
			$DB->query("SELECT COUNT(tid) as topics FROM ibf_topics WHERE approved = 1");
			$r = $DB->fetch_row();
			$stats['TOTAL_TOPICS'] = $r['topics'];
			$stats['TOTAL_TOPICS'] < 1 ? 0 : $stats['TOTAL_TOPICS'];
			
			$stats['TOTAL_REPLIES'] -= $stats['TOTAL_TOPICS'];
		}
		
		if ($IN['members'])
		{
			$DB->query("SELECT COUNT(uid) as members from ibf_members WHERE mgroup <> '".$INFO['auth_group']."'");
			$r = $DB->fetch_row();
			$stats['MEM_COUNT'] = $r['members'];
			// Remove "guest" account...
			$stats['MEM_COUNT']--;
			$stats['MEM_COUNT'] < 1 ? 0 : $stats['MEM_COUNT'];
		}
		
		if ($IN['lastreg'])
		{
			$DB->query("SELECT uid, uname FROM ibf_members WHERE mgroup <> '".$INFO['auth_group']."' ORDER BY uid DESC LIMIT 0,1");
			$r = $DB->fetch_row();
			$stats['LAST_MEM_NAME'] = $r['uname'];
			$stats['LAST_MEM_ID']   = $r['uid'];
		}
		
		if ($IN['online'])
		{
			$stats['MOST_DATE'] = time();
			$stats['MOST_COUNT'] = 1;
		}
		
		if ( count($stats) > 0 )
		{
			$db_string = $DB->compile_db_update_string( $stats );
			$DB->query("UPDATE ibf_stats SET $db_string");
		}
		else
		{
			$ADMIN->error("ûҪ¼ģ");
		}
		
		$ADMIN->done_screen("¼ͳ", "̨ҳ", "act=index" );
		
	}
	
	
	
	function countstats()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "ѡҪ¼ͳֵ";
		$ADMIN->page_title  = "¼ͳƿ";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'docount' ),
												  2 => array( 'act'   , 'op'     ),
									     )      );
									     
		//+-------------------------------
		
		$SKIN->td_header[] = array( "ͳ"    , "70%" );
		$SKIN->td_header[] = array( "ѡ"       , "30%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "¼ͳ" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "¼",
												  $SKIN->form_dropdown( 'posts', array( 0 => array( 1, ''  ), 1 => array( 0, '' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( "¼Ա",
												  $SKIN->form_dropdown( 'members', array( 0 => array( 1, ''  ), 1 => array( 0, '' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( "עԱ",
												  $SKIN->form_dropdown( 'lastreg', array( 0 => array( 1, ''  ), 1 => array( 0, '' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( " '߼¼' ͳƣ",
												  $SKIN->form_dropdown( 'online', array( 0 => array( 0, ''  ), 1 => array( 1, '' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('Щͳ');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//-------------------------------------------------------------
	// CALENDAR
	//--------------------------------------------------------------
	
	function calendar()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docalendar', '趨', '');
		
		$INFO['start_year'] = (isset($INFO['start_year'])) ? $INFO['start_year'] : 2001;
		$INFO['year_limit'] = (isset($INFO['year_limit'])) ? $INFO['year_limit'] : 5;
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ҳʾգ</b>" ,
										  $SKIN->form_yes_no( "show_bday_calendar", $INFO['show_bday_calendar'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̳ҳʾߣ</b>" ,
										  $SKIN->form_yes_no( "show_birthdays", $INFO['show_birthdays'] )
										  ."<br />".$SKIN->form_checkbox( "autohide_bday", $INFO["autohide_bday"] )." ޿ʾʱԶأ"
								 )      );
								 						 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾٵ¼</b><br>Ὣ¼ʾ̳ҳͳ" ,
										  $SKIN->form_yes_no( "show_calendar", $INFO['show_calendar'] )
										  ."<br />".$SKIN->form_checkbox( "autohide_calendar", $INFO["autohide_calendar"] )." ޿ʾʱԶأ"
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾδ [x] ¼</b><br>ѡ" ,
										  $SKIN->form_input( "calendar_limit", $INFO['calendar_limit']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> '' ѡĿʼ</b><br>ڼ / ¼" ,
										  $SKIN->form_input( "start_year", $INFO['start_year']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>'' ѡ</b><br>ڼ / ¼<br> 2002 ꣬ 5 - ѡ = 2007" ,
										  $SKIN->form_input( "year_limit", $INFO['year_limit']  )
								 )      );
								 
 		
								 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// URLs and ADDRESSES
	//--------------------------------------------------------------
	
	function board()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('doboard', '̳ر/', '');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ر̳</b><br>Ȩ޵ȻԽ̳" ,
										  $SKIN->form_yes_no( "board_offline", $INFO['board_offline'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ҪʾĹرѶϢ</b>" ,
										  $SKIN->form_textarea( "offline_msg", $INFO['offline_msg']  )
								 )      );
								 
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// EMOTICON FUNCTIONS
	//-------------------------------------------------------------

	function doedit_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		if ($IN['before'] == "")
		{
			$ADMIN->error("һҪȡ!");
		}

		if ($IN['id'] == "")
		{
			$ADMIN->error("һЧıͼʾ id!");
		}

		if ( strstr( $IN['before'], '&#092;' ) )
		{
			$ADMIN->error(" \"{$IN['before']}\" ʹ÷бַַ.");
		}

		$IN['clickable'] = $IN['clickable'] ? 1 : 0;

		$db_string = $DB->compile_db_update_string( array( 'code'      => $IN['before'],
														   'smile_url' => $IN['after'],
														   'clickable' => $IN['click'],
												  )      );

		$DB->query("UPDATE ibf_emoticons SET $db_string WHERE id='".$IN['id']."'");

		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();


	}

	//=====================================================


	function edit_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->page_detail = "༭ͼʾ";
		$ADMIN->page_title  = "༭ͼʾ";

		//+-------------------------------

		if ($IN['id'] == "")
		{
			$ADMIN->error("һЧĹ id!");
		}

		//+-------------------------------

		$DB->query("SELECT * FROM ibf_emoticons WHERE id='".$IN['id']."'");

		if ( ! $r = $DB->fetch_row() )
		{
			$ADMIN->error("޷Ͽҵñͼʾ");
		}

		//+-------------------------------

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'emo_doedit' ),
												  2 => array( 'act'   , 'op'     ),
												  3 => array( 'id'    , $IN['id'] ),
									     )      );



		$SKIN->td_header[] = array( "֮ǰ"  , "40%" );
		$SKIN->td_header[] = array( "֮"   , "40%" );
		$SKIN->td_header[] = array( "+ ɵѡ"  , "20%" );

		//+-------------------------------

		$emos = array();

		if (! is_dir($INFO['html_dir'].'/../../../uploads') )
		{
			$ADMIN->error("޷ҵͼʾĿ¼ - ȷ 'html_dir' ·׵");
		}

		//+-------------------------------


		$dh = opendir( $INFO['html_dir'].'/../../../uploads' ) or die("޷ҪȡıͼʾĿ¼·Ȩ");
 		while ( $file = readdir( $dh ) )
 		{
 			if ( preg_match( "/^smil.*/i", $file ) )
 			{
 				$emos[] = array( $file, $file );
 			}
 		}
 		closedir( $dh );

 		//+-------------------------------

		$ADMIN->html .= $SKIN->start_table( "༭ͼʾ" );

		$ADMIN->html .= "<script language='javascript'>
						 <!--
						 	function show_emo() {

						 		var emo_url = '{$INFO['html_url']}/../../../uploads/' + document.theAdminForm.after.options[document.theAdminForm.after.selectedIndex].value;

						 		document.images.emopreview.src = emo_url;
							}
						//-->
						</script>
						";

		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before', stripslashes($r['code']) ),
												  $SKIN->form_dropdown('after', $emos, $r['smile_url'], "onChange='show_emo()'") . "&nbsp;&nbsp;<img src='../../uploads/{$r['smile_url']}' name='emopreview' border='0'>",
												  $SKIN->form_dropdown( 'click', array( 0 => array( 1, ''  ), 1 => array( 0, '' ) ), $r['clickable'] )
										 )      );

		$ADMIN->html .= $SKIN->end_form('༭ͼʾ');

		$ADMIN->html .= $SKIN->end_table();

		$ADMIN->output();

	}

	//=====================================================

	function remove_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		if ($IN['id'] == "")
		{
			$ADMIN->error("һЧıͼʾ id!");
		}

		$DB->query("DELETE FROM ibf_emoticons WHERE id='".$IN['id']."'");

		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();


	}

	//=====================================================

	function add_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		if ($IN['before'] == "")
		{
			$ADMIN->error("Ҫûıͼʾ!");
		}

		if ( strstr( $IN['before'], '&#092;' ) )
		{
			$ADMIN->error(" \"{$IN['before']}\" ʹ÷бַַ.");
		}

		$IN['click'] = $IN['click'] ? 1 : 0;

		$db_string = $DB->compile_db_insert_string( array( 'code'       => $IN['before'],
														   'smile_url'  => $IN['after'],
														   'clickable'  => $IN['click'],
												  )      );

		$DB->query("INSERT INTO ibf_emoticons (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");

		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();


	}


	function perly_length_sort($a, $b)
	{
		if ( strlen($a['code']) == strlen($b['code']) )
		{
			return 0;
		}
		return ( strlen($a['code']) > strlen($b['code']) ) ? -1 : 1;
	}

	function perly_word_sort($a, $b)
	{
		if ( strlen($a['code']) == strlen($b['code']) )
		{
			return 0;
		}
		return ( strlen($a['code']) > strlen($b['code']) ) ? -1 : 1;
	}

	//=====================================================

	function upload_emoticon()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_FILES;

		$FILE_NAME = $HTTP_POST_FILES['FILE_UPLOAD']['name'];
		$FILE_SIZE = $HTTP_POST_FILES['FILE_UPLOAD']['size'];
		$FILE_TYPE = $HTTP_POST_FILES['FILE_UPLOAD']['type'];

		// Naughty Opera adds the filename on the end of the
		// mime type - we don't want this.

		$FILE_TYPE = preg_replace( "/^(.+?);.*$/", "\\1", $FILE_TYPE );

		if (! is_dir($INFO['html_dir'].'../../../uploads') )
		{
			$ADMIN->error("޷ҵͼʾĿ¼ - ȷ 'html_dir' ·Ƿ趨ȷ");
		}

		// Naughty Mozilla likes to use "none" to indicate an empty upload field.
		// I love universal languages that aren't universal.

		if ($HTTP_POST_FILES['FILE_UPLOAD']['name'] == "" or !$HTTP_POST_FILES['FILE_UPLOAD']['name'] or ($HTTP_POST_FILES['FILE_UPLOAD']['name'] == "none") )
		{
			$ADMIN->error("ûѡҪϴĵ!");
		}

		//-------------------------------------------------
		// Copy the upload to the uploads directory
		//-------------------------------------------------

		if (! @move_uploaded_file( $HTTP_POST_FILES['FILE_UPLOAD']['tmp_name'], $INFO['html_dir'].'../../../uploads'."/"."smiles-".$FILE_NAME) )
		{
			$ADMIN->error("ϴʧ");
		}
		else
		{
			@chmod( $INFO['html_dir'].'../../../uploads'."/".$FILE_NAME, 0777 );
		}

		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();


	}

	function emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->page_detail = "/༭Ƴͼʾ.<br>ֻѡѾϴ <font color=blue>'yoursite.com/uploads'</font> Ŀ¼ıͼʾ<br><br>ɵѡ뷢 'ɵѡͼʾ' еıͼʾй.";
		$ADMIN->page_title  = "ͼʾ";

		//+-------------------------------

		$SKIN->td_header[] = array( "֮ǰ"      , "30%" );
		$SKIN->td_header[] = array( "֮"       , "30%" );
		$SKIN->td_header[] = array( "+ ɵѡ" , "20%" );
		$SKIN->td_header[] = array( "༭"        , "10%" );
		$SKIN->td_header[] = array( "Ƴ"      , "10%" );

		//+-------------------------------



		$ADMIN->html .= $SKIN->start_table( "Ŀǰıͼʾ" );

		$DB->query("SELECT * from ibf_emoticons");

		$emo_url = $INFO['html_url'] . '/../../../uploads';

		$smilies = array();

		if ( $DB->get_num_rows() )
		{
			while ( $r = $DB->fetch_row() )
			{
				$smilies[] = $r;
			}

			usort($smilies, array( 'ad_settings', 'perly_length_sort' ) );

			foreach( $smilies as $array_idx => $r )
			{

				$click = $r['clickable'] ? '' : '';

				$ADMIN->html .= $SKIN->add_td_row( array( stripslashes($r['code']),
														  "<center><img src='$emo_url/{$r['smile_url']}'></center>",
														  "<center>$click</center>",
														  "<center><a href='".$SKIN->base_url."&act=op&code=emo_edit&id={$r['id']}'>༭</a></center>",
														  "<center><a href='".$SKIN->base_url."&act=op&code=emo_remove&id={$r['id']}'>Ƴ</a></center>",
												 )      );



			}
		}

		$ADMIN->html .= $SKIN->end_table();

		//+-------------------------------

		$emos = array();

		if (! is_dir($INFO['html_dir'].'../../../uploads') )
		{
			$ADMIN->error("޷ҵͼʾĿ¼ - ȷ 'html_dir' ·Ƿȷ");
		}

		//+-------------------------------

		$cnt   = 0;
		$start = "";

		$dh = opendir( $INFO['html_dir'].'../../../uploads' ) or die("޷ͼʾĿ¼Խжȡ·Ȩ");
 		while ( $file = readdir( $dh ) )
 		{
			if (preg_match("/^smil.*/i",$file))
 			{
 				$emos[] = array( $file, $file );

 				if ($cnt == 0)
 				{
 					$cnt = 1;
 					$start = $file;
 				}
 			}
 		}
 		closedir( $dh );

 		//+-------------------------------

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'emo_add' ),
												  2 => array( 'act'   , 'op'     ),
									     )      );


		$SKIN->td_header[] = array( "֮ǰ"       , "40%" );
		$SKIN->td_header[] = array( "֮"        , "40%" );
		$SKIN->td_header[] = array( "+ ɵѡ"  , "20%" );

		//+-------------------------------

		$ADMIN->html .= "<script language='javascript'>
						 <!--
						 	function show_emo() {

						 		var emo_url = '{$INFO['html_url']}/../../../uploads/' + document.theAdminForm.after.options[document.theAdminForm.after.selectedIndex].value;

						 		document.images.emopreview.src = emo_url;
							}
						//-->
						</script>
						";

		$ADMIN->html .= $SKIN->start_table( "ͼʾ" );

		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before'),
												  $SKIN->form_dropdown('after', $emos, "", "onChange='show_emo()'") . "&nbsp;&nbsp;<img src='../../uploads/$start' name='emopreview' border='0'>",
												  $SKIN->form_dropdown( 'click', array( 0 => array( 1, 'Yes'  ), 1 => array( 0, 'No' ) ) )
										 )      );

		$ADMIN->html .= $SKIN->end_form('ӱͼʾ');

		$ADMIN->html .= $SKIN->end_table();

		//+-------------------------------
		//+-------------------------------

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'emo_upload' ),
												  2 => array( 'act'   , 'op'     ),
												  3 => array( 'MAX_FILE_SIZE', '10000000000' ),
									     ) , "uploadform", " enctype='multipart/form-data'"     );


		$SKIN->td_header[] = array( "&nbsp;"       , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"       , "60%" );


		$ADMIN->html .= $SKIN->start_table( "ϴһͼʾͼʾĿ¼" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ĵѡһҪϴĵ</b><br>ϴ֮󣬿ıѡñͼʾ.",
												  $SKIN->form_upload(),
										 )      );

		$ADMIN->html .= $SKIN->end_form('ϴͼʾ');

		$ADMIN->html .= $SKIN->end_table();

		$ADMIN->output();

	}

	//-------------------------------------------------------------
	// BADWORD FUNCTIONS
	//--------------------------------------------------------------
	
	
	function doedit_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['before'] == "")
		{
			$ADMIN->error("һҪȡֻ㣬");
		}
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("һЧĹ id");
		}
		
		$IN['match'] = $IN['match'] ? 1 : 0;
		
		strlen($IN['swop']) > 1 ?  $IN['swop'] : "";
		
		$db_string = $DB->compile_db_update_string( array( 'type'    => $IN['before'],
														   'swop'    => $IN['after'],
														   'm_exact' => $IN['match'],
												  )      );
												  
		$DB->query("UPDATE ibf_badwords SET $db_string WHERE wid='".$IN['id']."'");
		
		$std->boink_it($SKIN->base_url."&act=op&code=bw");
		exit();
			
		
	}
	
	//=====================================================
	
	function edit_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "༭ѡĹ";
		$ADMIN->page_title  = "ֻ";
		
		//+-------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("һЧĹ id");
		}
		
		//+-------------------------------
		
		$DB->query("SELECT * FROM ibf_badwords WHERE wid='".$IN['id']."'");
		
		if ( ! $r = $DB->fetch_row() )
		{
			$ADMIN->error("޷Ͽҵù");
		}
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'bw_doedit' ),
												  2 => array( 'act'   , 'op'     ),
												  3 => array( 'id'    , $IN['id'] ),
									     )      );
		
		
		
		$SKIN->td_header[] = array( "֮ǰ"  , "40%" );
		$SKIN->td_header[] = array( "֮"   , "40%" );
		$SKIN->td_header[] = array( "ģʽ"  , "20%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "༭" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before', stripslashes($r['type']) ),
												  $SKIN->form_input('after' , stripslashes($r['swop']) ),
												  $SKIN->form_dropdown( 'match', array( 0 => array( 1, 'ȷ'  ), 1 => array( 0, '' ) ), $r['m_exact'] )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('༭');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//=====================================================
	
	function remove_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("һЧĹ id");
		}
		
		$DB->query("DELETE FROM ibf_badwords WHERE wid='".$IN['id']."'");
		
		$std->boink_it($SKIN->base_url."&act=op&code=bw");
		exit();
			
		
	}
	
	//=====================================================
	
	function add_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['before'] == "")
		{
			$ADMIN->error("һҪȡֻ㣬");
		}
		
		$IN['match'] = $IN['match'] ? 1 : 0;
		
		strlen($IN['swop']) > 1 ?  $IN['swop'] : "";
		
		$db_string = $DB->compile_db_insert_string( array( 'type'    => $IN['before'],
														   'swop'    => $IN['after'],
														   'm_exact' => $IN['match'],
												  )      );
												  
		$DB->query("INSERT INTO ibf_badwords (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
		
		$std->boink_it($SKIN->base_url."&act=op&code=bw");
		exit();
			
		
	}
	
	//=====================================================
	
	function badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "/༭Ƴֻˡ<br>ֻӻԱ¡ǩΧȡ<br><br><b>ɷ</b> 'hell' һֻ㣬Ὣ 'hell'  'hello' ȡΪֻ 6 ֺ (ִСд)<br><br><b>ȷ</b> 'hell' һֻ㣬ֻὫ 'hell' ȡΪֻ 6 ֺ (ִСд)";
		$ADMIN->page_title  = "ֻ";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'bw_add' ),
												  2 => array( 'act'   , 'op'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "֮ǰ"  , "30%" );
		$SKIN->td_header[] = array( "֮"   , "30%" );
		$SKIN->td_header[] = array( "ģʽ"  , "20%" );
		$SKIN->td_header[] = array( "༭"    , "10%" );
		$SKIN->td_header[] = array( "Ƴ"  , "10%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ŀǰ" );
		
		$DB->query("SELECT * from ibf_badwords");
		
		if ( $DB->get_num_rows() )
		{
			while ( $r = $DB->fetch_row() )
			{
				$words[] = $r;
			}
			
			usort($words, array( 'ad_settings', 'perly_word_sort' ) );
			
			foreach($words as $idx => $r)
			{
			
				$replace = $r['swop']    ? stripslashes($r['swop']) : '######';
				
				$method  = $r['m_exact'] ? 'ȷ' : '';
				
				$ADMIN->html .= $SKIN->add_td_row( array( stripslashes($r['type']),
														  $replace,
														  $method,
														  "<center><a href='".$SKIN->base_url."&act=op&code=bw_edit&id={$r['wid']}'>༭</a></center>",
														  "<center><a href='".$SKIN->base_url."&act=op&code=bw_remove&id={$r['wid']}'>Ƴ</a></center>",
												 )      );
			}
			
		}
		
		$ADMIN->html .= $SKIN->end_table();
		
		
		$SKIN->td_header[] = array( "֮ǰ"  , "40%" );
		$SKIN->td_header[] = array( "֮"   , "40%" );
		$SKIN->td_header[] = array( "ģʽ"  , "20%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before'),
												  $SKIN->form_input('after'),
												  $SKIN->form_dropdown( 'match', array( 0 => array( 1, 'ȷ'  ), 1 => array( 0, '' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('ӹ');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//-------------------------------------------------------------
	// NEWS
	//--------------------------------------------------------------
	
	function news()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('donews', 'Ż趨', '');
		
		$DB->query("SELECT id, name FROM ibf_forums ORDER BY name");
		
		$form_array = array();
		
		while ( $r = $DB->fetch_row() )
		{
			$form_array[] = array( $r['id'], $r['name'] );
		}
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ĸ⣿</b>" ,
										  $SKIN->form_dropdown( "news_forum_id", $form_array, $INFO['news_forum_id']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾ 'Ϣ' ̳ҳ</b>" ,
										  $SKIN->form_yes_no( "index_news_link", $INFO['index_news_link']  )
								 )      );
		
		
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// PM
	//--------------------------------------------------------------
	
	function pm()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dopm', 'Ѷ趨', '');
		
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѶϢʹ IBF Code</b>" ,
										  $SKIN->form_yes_no( "msg_allow_code", $INFO['msg_allow_code']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѶϢʹ HTML</b>" ,
										  $SKIN->form_yes_no( "msg_allow_html", $INFO['msg_allow_html']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѶϢбʱÿҳʾѶϢ</b><br>ԤΪ 50" ,
										  $SKIN->form_input( "show_max_msg_list", $INFO['show_max_msg_list']  )
								 )      );

		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// EMAIL functions
	//--------------------------------------------------------------
	
	function email()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('doemail', 'ʼ趨', '趨');
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ʼλַ', 'left', 'catrow2' );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̳յʼλַ</b>" ,
										  $SKIN->form_input( "email_in", $INFO['email_in']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̳ĵʼλַ</b>" ,
										  $SKIN->form_input( "email_out", $INFO['email_out']  )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_basic( 'ʵݷʽ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʵݷʽ</b><br> PHP  mail() ʹãѡ SMTP" ,
										  $SKIN->form_dropdown( "mail_method", 
										  						 array(
										  						 		0 => array( 'mail', 'PHP mail()' ),
										  						 		1 => array( 'smtp', 'SMTP'  ),
										  						 	  ),
										  						 $INFO['mail_method']  )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_basic( 'SMTP ѡ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> SMTP </b><br>Ԥ 'localhost'" ,
										  $SKIN->form_input( "smtp_host", $INFO['smtp_host']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> SMTP ţ</b><br>Ԥ 25" ,
										  $SKIN->form_input( "smtp_port", $INFO['smtp_port']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>SMTP ʹ</b><br>ʹ 'localhost' ʱ벻Ҫ" ,
										  $SKIN->form_input( "smtp_user", $INFO['smtp_user']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>SMTP </b><br>ʹ 'localhost' ʱ벻Ҫ" ,
										  $SKIN->form_input( "smtp_pass", $INFO['smtp_pass'], 'password'  )
								 )      );
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// URLs and ADDRESSES
	//--------------------------------------------------------------
	
	function url()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dourl', '趨', '趨');
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_basic( '̳ HTTP λַ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̳</b>" ,
										  $SKIN->form_input( "board_name", $INFO['board_name']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ַ̳</b>" ,
										  $SKIN->form_input( "board_url", $INFO['board_url']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>վ</b>" ,
										  $SKIN->form_input( "home_name", $INFO['home_name']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>վλַ</b>" ,
										  $SKIN->form_input( "home_url", $INFO['home_url']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>HTML URL</b><br>ͼƬ...ȵ" ,
										  $SKIN->form_input( "html_url", $INFO['html_url']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϴ URL</b>" ,
										  $SKIN->form_input( "upload_url", $INFO['upload_url']  )
								 )      );
								 					 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '̳·', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>'html' Ŀ¼·</b><br>ע⣺· URL" ,
										  $SKIN->form_input( "html_dir", $INFO['html_dir']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϴĿ¼</b>" ,
										  $SKIN->form_input( "upload_dir", $INFO['upload_dir']  )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'HTTP ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> HTTP ͷ</b><br>(ĳЩ NT װҪ˹ر)" ,
										  $SKIN->form_yes_no( "print_headers", $INFO['print_headers'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b><i>ȡ</I> GZIP 룿</b><br>(GZIP ԼӿҳĴͼƵʹ)" ,
										  $SKIN->form_yes_no( "disable_gzip", $INFO['disable_gzip'] )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Զµͣ</b><br>(ڿҳµ)" ,
										  $SKIN->form_dropdown( 'header_redirect', 
										  						 array(
										  						 		0 => array( 'location', 'λ̬ (*nix savvy)' ),
										  						 		1 => array( 'refresh' , ' (Windows savvy)' ),
										  						 		2 => array( 'html'    , 'HTML META µ (ʧܵĻ...)' ),
										  						 	  ),
										  						 $INFO['header_redirect']  )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>㼶</b>" ,
										  $SKIN->form_dropdown( "debug_level", 
										  						 array(
										  						 		0 => array( 0, '0: None - ҪʾκγѶ' ),
										  						 		1 => array( 1, '1: ʾءҳʱ估ѯ' ),
										  						 		2 => array( 2, '2: ʾ㼶 1 ()  GETPOST Ѷ'),
										  						 		3 => array( 3, '3: ʾ㼶 1 + 2 Ͽѯ'),
										  						 	  ),
										  						 $INFO['debug_level']  )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b><i></I> SQL ģʽ</b><br>(ǣ '&debug=1' ӵκҳԱ mySQL Ѷ)" ,
										  $SKIN->form_yes_no( "sql_debug", $INFO['sql_debug'] )
								 )      );
		
                //-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_basic( '½Ա˽ѶϢ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹԶѶϢ?</b><br>(,½Ա½󽫻յ˽ѶϢ)" ,
										  $SKIN->form_yes_no( "auto_pm_on", $INFO['auto_pm_on'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>?</b><br>(һID)" ,
										  $SKIN->form_input( "auto_pm_from", $INFO['auto_pm_from'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѶϢ</b><br>(Զ͵ѶϢ)" ,
										  $SKIN->form_input( "auto_pm_subject", $INFO['auto_pm_subject'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѶϢ</b><br>(Զ͵ѶϢ)" ,
										  $SKIN->form_textarea( "auto_pm_message", $INFO['auto_pm_message'] )
								 )      );

		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '趨', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹðȫģʽ壿</b><br>(ע⣺Զ/༭壬ıܱ֮ٴͬģ)" ,
										  $SKIN->form_dropdown( 'safe_mode_skins', 
										  						 array(
										  						 		0 => array( '0', '' ),
										  						 		1 => array( '1' , '' ),
										  						 	  ),
										  						 $INFO['safe_mode_skins']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ָʽ</b><br>ѡڷָǧٵԪ<br>(磺Ӣʹö)" ,
										  $SKIN->form_dropdown( 'number_format', 
										  						 array(
										  						 		0 => array( '', 'ʹ' ),
										  						 		1 => array( 'ո' , 'ո' ),
										  						 		2 => array( ',' , ',' ),
										  						 		3 => array( '.' , '.' ),
										  						 	  ),
										  						 $INFO['number_format']  )
								 )      );
								 
 
		$this->common_footer();
	
	
	}
	
	
	
	//-------------------------------------------------------------
	// CPU SAVING
	//--------------------------------------------------------------
	
	function cpu()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docpu', 'CPU ʡ', 'ѡرĳЩԽʡԴĺ');
		
		
		if ($INFO['au_cutoff'] == "")
		{
			$INFO['au_cutoff'] = 15;
		}
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'SQL ʡ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾʹߣ</b>" ,
										  $SKIN->form_yes_no( "show_active", $INFO['show_active'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾɷڵĻʹ</b>" ,
										  $SKIN->form_input( "au_cutoff", $INFO['au_cutoff'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾգ</b>" ,
										  $SKIN->form_yes_no( "show_birthdays", $INFO['show_birthdays'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾ̳ͳƣ</b>" ,
										  $SKIN->form_yes_no( "show_totals", $INFO['show_totals'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹԶλѶ</b>" ,
										  $SKIN->form_yes_no( "custom_profile_topic", $INFO['custom_profile_topic'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾʱʹ߲뷢⣿</b>" ,
										  $SKIN->form_yes_no( "show_user_posted", $INFO['show_user_posted'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ƴ 'ʹ <u></u>' ܣ</b><br>(ÿμʱԽʡ 1 ѯ)" ,
										  $SKIN->form_yes_no( "no_au_forum", $INFO['no_au_forum'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ƴ 'ʹ <u></u>' ܣ</b><br>(ÿμʱԽʡ 1 ѯ)" ,
										  $SKIN->form_yes_no( "no_au_topic", $INFO['no_au_topic'] )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'CPU ʡ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b></b><br>ﵽʱʾ 'æµ' ѶϢ<br>ղ" ,
										  $SKIN->form_input( "load_limit", $INFO['load_limit']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ (ĵط) ʹ</b>" ,
										  $SKIN->form_yes_no( "allow_search", $INFO['allow_search'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>² [x] Ԫ</b><br>ʾʱ<br>ջʵĸʽƪ" ,
										  $SKIN->form_input( "search_post_cut", $INFO['search_post_cut'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Сִ</b><br>϶̵ִԴظĽ 'if', 'at', ȵ" ,
										  $SKIN->form_input( "min_search_word", $INFO['min_search_word'] )."<br>ע⣬ȫļ 4 Ԫ޷ IPB "
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'Ƶʡ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> HTTP ޿ȡͷ</b><br>(ֹͣȡҳ)" ,
										  $SKIN->form_yes_no( "nocache", $INFO['nocache'] )
								 )      );
								 
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾ̵Ծб</b><br>ὫбƳ - кܶõ" ,
										  $SKIN->form_yes_no( "short_forum_jump", $INFO['short_forum_jump'] )
								 )      );
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// DATES
	//--------------------------------------------------------------
	
	function dates()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dodates', '', 'ڸʽ');
		
		$time_array = array();
		
		require ROOT_PATH."lang/tw/lang_ucp.php";
		
		foreach( $lang as $off => $words )
 		{
 			if (preg_match("/^time_(\S+)$/", $off, $match))
 			{
 				$time_select[] = array( $match[1], $words );
 			}
 		}
 		
 		$d_date = $std->get_date(time(), 'LONG');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʱ</b><br><span style='color:red'>ѾѡȷʱʱһСʱΪʱƵԵʣĻԱԾʹ߿̨༭ǵ '̳趨' У</span>" ,
										  $SKIN->form_dropdown( "time_offset", $time_select, $INFO['time_offset']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʱ ()</b><br>΢ʱ䣬Ҫӷʱӣֿͷ '-' ()" ,
										  $SKIN->form_input( "time_adjust", $INFO['time_adjust'] ) . "<br>̳ʱ (ۺʱĿǰĵ) Ϊ $d_date"
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʱʽ</b><br>÷ʽ <a href='http://www.php.net/date' target='_blank'>PHP </a> ͬ" ,
										  $SKIN->form_input( "clock_short", $INFO['clock_short'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>עʱʽ</b><br>÷ʽ <a href='http://www.php.net/date' target='_blank'>PHP </a> ͬ" ,
										  $SKIN->form_input( "clock_joined", $INFO['clock_joined'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʱʽ</b><br>÷ʽ <a href='http://www.php.net/date' target='_blank'>PHP </a> ͬ" ,
										  $SKIN->form_input( "clock_long", $INFO['clock_long'] )
								 )      );
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// AVATARS
	//--------------------------------------------------------------
	
	function avatars()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('doavatars', 'ʹ߸', 'ʹ߸Ȩ');
		
		$INFO['avatar_ext'] = preg_replace( "/\|/", ",", $INFO['avatar_ext'] );
		$INFO['photo_ext']  = preg_replace( "/\|/", ",", $INFO['photo_ext'] );
		
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ʹ߸ & ѡ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Աѡ壿</b>" ,
										  $SKIN->form_yes_no( "allow_skins", $INFO['allow_skins'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Աͷ</b><br>ȫֹ" ,
										  $SKIN->form_input( "post_titlechange", $INFO['post_titlechange'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>λλĳ (λԪ)</b>" ,
										  $SKIN->form_input( "max_location_length", $INFO['max_location_length'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ȥλĳ (λԪ)</b>" ,
										  $SKIN->form_input( "max_interest_length", $INFO['max_interest_length'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹǩλĳ (λԪ)</b>" ,
										  $SKIN->form_input( "max_sig_length", $INFO['max_sig_length'] )
								 )      );						 
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ǩʹ HTML</b>" ,
										  $SKIN->form_yes_no( "sig_allow_html", $INFO['sig_allow_html'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ǩʹ IBF Code</b>" ,
										  $SKIN->form_yes_no( "sig_allow_ibc", $INFO['sig_allow_ibc'] )
								 )      );
								 
		if ($INFO['postpage_contents'] == "")
		{
			$INFO['postpage_contents'] = '5,10,15,20,25,30,35,40';
		}
		
		if ($INFO['topicpage_contents'] == "")
		{
			$INFO['topicpage_contents'] = '5,10,15,20,25,30,35,40';
		}
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ߿ѡÿҳѡ</b><br>ԶŸԶ 'ʹ̳Ԥ'<br> 5,15,20,25,30" ,
										  $SKIN->form_input( "postpage_contents", $INFO['postpage_contents'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ߿ѡҳѡ</b><br>ԶŸԶ 'ʹ̳Ԥ'<br> 5,15,20,25,30" ,
										  $SKIN->form_input( "topicpage_contents", $INFO['topicpage_contents'] )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ⳬ [x] ûлظԶȡ</b><br>򲻻Զȡ" ,
										  $SKIN->form_input( "subs_autoprune", $INFO['subs_autoprune'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ƭ URL </b><br>ԶŸ (gif,png,jpeg) ȵ" ,
										  $SKIN->form_input( "photo_ext", strlen($INFO['photo_ext']) > 1 ? $INFO['photo_ext'] : "gif,jpg,jpeg,png" )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ͼƬ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ֹ IPB ԶСŵƬ/ͼƬ</b><br/ >ҪԱߴ" ,
										  $SKIN->form_yes_no( "disable_ipbsize", $INFO['disable_ipbsize'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹøͼƬ</b>" ,
										  $SKIN->form_yes_no( "avatars_on", $INFO['avatars_on'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͼƬ</b><br>ԶŸ (gif,png,jpeg) ȵ" ,
										  $SKIN->form_input( "avatar_ext", $INFO['avatar_ext'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹԶ URL ͼƬ</b>" ,
										  $SKIN->form_yes_no( "avatar_url", $INFO['avatar_url'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϴĸͼƬСޣ (K)</b>" ,
										  $SKIN->form_input( "avup_size_max", $INFO['avup_size_max'] )
								 )      );
 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͼƬߴ</b><br>(<b>x</b>)" ,
										  $SKIN->form_input( "avatar_dims", $INFO['avatar_dims'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԤĸͼƬߴ</b><br>(<b>x</b>)" ,
										  $SKIN->form_input( "avatar_def", $INFO['avatar_def'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͼƬλ</b>" ,
										  $SKIN->form_input( 'av_gal_cols' 	, $INFO['av_gal_cols'] = $INFO['av_gal_cols'] ? $INFO['av_gal_cols'] : 5 )
								 )      );						 
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ÿȨ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿͿǩ</b>" ,
										  $SKIN->form_yes_no( "guests_sig", $INFO['guests_sig'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿͿͼƬ</b>" ,
										  $SKIN->form_yes_no( "guests_img", $INFO['guests_img'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿͿʹ߸ͼƬ</b>" ,
										  $SKIN->form_yes_no( "guests_ava", $INFO['guests_ava'] )
								 )      );
								 
			     
								 					 
		$this->common_footer();
	
	
	}
	
	
	//-------------------------------------------------------------
	// TOPICS and POSTS
	//--------------------------------------------------------------
	
	function post()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$INFO['img_ext'] = preg_replace( "/\|/", ",", $INFO['img_ext'] );
	
		$this->common_header('dopost', '⡢¼', '趨ɼķԪغ');
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------	
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿҳ</b>" ,
										  $SKIN->form_input( "display_max_topics", $INFO['display_max_topics'] )
								 )      );
									     
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾΪ '' </b>" ,
										  $SKIN->form_input( "hot_topic", $INFO['hot_topic'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̶ǰ</b>" ,
										  $SKIN->form_input( "pre_pinned", $INFO['pre_pinned'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ǰ</b>" ,
										  $SKIN->form_input( "pre_moved", $INFO['pre_moved'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͶƱǰ</b>" ,
										  $SKIN->form_input( "pre_polls", $INFO['pre_polls'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ֹ</b><br>(Ὣ CLICK HERE תΪ Click Here)<br><font color=red>עѡĻ⡣</font>" ,
										  $SKIN->form_yes_no( "etfilter_shout", $INFO['etfilter_shout'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ƴ϶ľ̾/ʺţ</b><br>(Ὣ This!!!!! תΪ This!)" ,
										  $SKIN->form_yes_no( "etfilter_punct", $INFO['etfilter_punct'] )
								 )      );						 
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( ' & ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------	
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿҳ</b>" ,
										  $SKIN->form_input( "display_max_posts", $INFO['display_max_posts'] )
								 )      );						 
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿһпɰıͼʾ</b>" ,
										  $SKIN->form_input( "emo_per_row", $INFO['emo_per_row'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿƪ¿õıͼʾ</b>" ,
										  $SKIN->form_input( "max_emos", $INFO['max_emos'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿƪ¿ͼƬ</b>" ,
										  $SKIN->form_input( "max_images", $INFO['max_images'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿƪµĴС (ǧλԪ [kb])</b>" ,
										  $SKIN->form_input( "max_post_length", $INFO['max_post_length'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> Flash ӰƬ ( pixels)</b>" ,
										  $SKIN->form_input( "max_w_flash", $INFO['max_w_flash'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> Flash ӰƬ߶ ( pixels)</b>" ,
										  $SKIN->form_input( "max_h_flash", $INFO['max_h_flash'] )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ЧͼƬ</b><br>(Զŷָ (gif,jpeg,jpg) ȵ" ,
										  $SKIN->form_input( "img_ext", $INFO['img_ext'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʾϴͼƬ</b>" ,
										  $SKIN->form_yes_no( "show_img_upload", $INFO['show_img_upload'] )
										 ."<br />".$SKIN->form_checkbox( 'siu_thumb', $INFO['siu_thumb'] )."ʾͼ С ".$SKIN->form_simple_input( 'siu_width', $INFO['siu_width'] )." x ".$SKIN->form_simple_input( 'siu_height', $INFO['siu_height'] )
								 )      );					 
		
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ֹǶԣ</b><br>ὫõںκƳ<br><a href='#' title='κε壬ô IQ һߡ'>..</a>" ,
										  $SKIN->form_yes_no( "strip_quotes", $INFO['strip_quotes'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿ <i></i></b><br>(ÿԱͬƷʱԱ)" ,
										  $SKIN->form_input( "guest_name_pre", $INFO['guest_name_pre'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿ <i>β</i></b><br>(ÿԱͬƷʱԱ)" ,
										  $SKIN->form_input( "guest_name_suf", $INFO['guest_name_suf'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ֻеԪ</b><br>ֹ񱻳Ԫſ 80 - 100<br><font color=red>עĻ⣬Ҫʹ</font>" ,
										  $SKIN->form_input( "post_wordwrap", $INFO['post_wordwrap'] )
								 )      );
//-- mod_resize_image begin ͼ
        global $mod_rsi;
        $mod_rsi->ad_settings();
//-- mod_resize_image end ͼ


		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ͶƱ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͶƱѡʹ [IMG]  [URL] ǩ</b>" ,
										  $SKIN->form_yes_no( "poll_tags", $INFO['poll_tags'] )
								 )      );
								 						 						 					 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͶƱѡ</b><br>" ,
										  $SKIN->form_input( "max_poll_choices", $INFO['max_poll_choices'] ? $INFO['max_poll_choices'] : 10)
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԱͶƱɥʧͶƱȨ</b>" ,
										  $SKIN->form_yes_no( 'allow_result_view', $INFO['allow_result_view'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ȡԱ 'Ҫظ' ͶƱ</b>" ,
										  $SKIN->form_yes_no( 'poll_disable_noreply', $INFO['poll_disable_noreply'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ⷢ߿⸽ͶƱʱ (Сʱ)</b><br>ԹԱ򳬼ûӰ" ,
										  $SKIN->form_input( 'startpoll_cutoff', $INFO['startpoll_cutoff'] ? $INFO['startpoll_cutoff'] : 24)
								 )      );
								 					 						 						 						 					 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// SECURITY
	//--------------------------------------------------------------
	
	function secure()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dosecure', 'ȫ', 'ʹö̳İȫԴ㼶');

		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ȫ (ʽ/˹ˮ)', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʽ/˹ˮƣ</b><br>ǿʹעʼλַʱ...ȵȣԷֹ˴ͳ".$SKIN->js_help_link('s_reg_antispam') ,
										  $SKIN->form_dropdown( "bot_antispam", 
										  						array(
										  								0 => array( '0'    , ''                  ),
										  								1 => array( 'gd'   , ' (Ҫ GD ʽ)'    ),
										  								2 => array( 'gif'  , '׼ (Ҫ)'  ),
										  								
										  							 ),
										  					    $INFO['bot_antispam']
										  					  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> GD ʱʹ [] TTF  [] </b><br />õĻTTF ѵ" ,
										  $SKIN->form_yes_no( "use_ttf", isset($INFO['use_ttf']) ? $INFO['use_ttf'] : 1 )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ GD & TTFӰ</b>" ,
										  $SKIN->form_input( "gd_width", isset($INFO['gd_width']) ? $INFO['gd_width'] : 250 )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ GD & TTFӰ߶</b>" ,
										  $SKIN->form_input( "gd_height", isset($INFO['gd_height']) ? $INFO['gd_height'] : 70 )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ GD & TTFҪʹõ .ttf ·</b>" ,
										  $SKIN->form_input( "gd_font", isset($INFO['gd_font']) ? $INFO['gd_font'] : getcwd().'/fonts/progbot.ttf' )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ȫ ()', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̬ͼƬ</b><br> '' ʹ߿ʽͼƬ" ,
										  $SKIN->form_yes_no( "allow_dynamic_img", $INFO['allow_dynamic_img'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Session  ()</b><br>ƳѾָ޵ sessions" ,
										  $SKIN->form_input( "session_expiration", $INFO['session_expiration'] )
								 )      );
 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>֤ʱʹߵ</b>" ,
										  $SKIN->form_yes_no( "match_browser", $INFO['match_browser'] )
								 )      );
								 
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ȫ ()', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹðȫʼΪԱ֮ʼ</b><br>ʹߵĵʼλַ" ,
										  $SKIN->form_yes_no( "use_mail_form", $INFO['use_mail_form'] )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ȫ ()', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------						 
								 					 
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͼƬ</b><br>׵ĳʽʦܹǿͼƬʽִУ IBF Σԡ" ,
										  $SKIN->form_yes_no( "allow_images", $INFO['allow_images'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>мͼƬʹ flash ӰƬ</b><br>Flash ڽĳʽԣпΣȫԡ" ,
										  $SKIN->form_yes_no( "allow_flash", $INFO['allow_flash'] )
								 )      );	
								 
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ȫ (ʹ)', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------						 					 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹעʱظĵʼ</b><br>Ƿͬĵʼλַ" ,
										  $SKIN->form_yes_no( "allow_dup_email", $INFO['allow_dup_email'] )
								 )      );
		
						 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Եʼ֤ע᣿</b><br>Ա˹Ԥµʺţʹǵĵʼλַ֤" ,
										  $SKIN->form_dropdown( "reg_auth_type", 
										  						array(
										  								0 => array( 'user' , 'ʹߵʼ֤' ),
										  								1 => array( 'admin', 'Ա֤'      ),
										  								2 => array( '0'    , ''                  )
										  							 ),
										  					    $INFO['reg_auth_type']
										  					  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ƴδע...</b>" ,
										  $SKIN->form_simple_input( 'validate_day_prune', $INFO['validate_day_prune'], 3 ). "... ֮"
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>עʱԵʼ֪ͨԱ</b>" ,
										  $SKIN->form_dropdown( "new_reg_notify", 
										  						array(
										  								0 => array( '1' , '' ),
										  								1 => array( '0' , ''  )
										  							 ),
										  					    $INFO['new_reg_notify']
										  					  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ǿƷÿ͵½ſ̳</b>" ,
										  $SKIN->form_yes_no( "force_login", $INFO['force_login'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ֹע᣿</b>" ,
										  $SKIN->form_yes_no( "no_reg", $INFO['no_reg'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ƴ chr(0xCA)</b><br />Ԫɱ '' Ŀհðע - ڷŷԪ趨ıܻ⡣<br /><font color=red>עĻ⣬Ҫʹá</font>" ,
										  $SKIN->form_yes_no( 'strip_space_chr', $INFO['strip_space_chr'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ȡ 'ٴƪ' ᣿</b>" ,
										  $SKIN->form_yes_no( "disable_reportpost", $INFO['disable_reportpost'] )
								 )      ); // 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ˮӳ ()</b><br>ʹȴʱ֮ٴη<br>ղйˮ" ,
										  $SKIN->form_input( "flood_control", $INFO['flood_control'] )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '˽', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------	
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹԱб</b>" ,
										  $SKIN->form_yes_no( "allow_online_list", $INFO['allow_online_list'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ֹ߹Ⱥʹߣ</b><br>ʹǵƺǺ" ,
										  $SKIN->form_yes_no( "disable_admin_anon", $INFO['disable_admin_anon'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ֹ߹Ⱥбеʹ IP λַ</b>" ,
										  $SKIN->form_yes_no( "disable_online_ip", $INFO['disable_online_ip'] )
								 )      );
								 
		
								 					 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// COOKIES: Yum Yum!
	//--------------------------------------------------------------
	
	function cookie()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docookie', 'Cookies', 'Щλȫաʵ鿴ҳȷ趨');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cookie </b><br>ʾʹ <b>.your-domain.com</b> Ϊ cookies" ,
										  $SKIN->form_input( "cookie_domain", $INFO['cookie_domain'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cookie </b><br>̳ͬһ" ,
										  $SKIN->form_input( "cookie_id", $INFO['cookie_id'] )
								 )      );
 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cookie ·</b><br> IBF Ŀ¼·" ,
										  $SKIN->form_input( "cookie_path", $INFO['cookie_path'] )
								 )      );
		
		$this->common_footer();
	
	
	}
	

//Ǯhacjʼ
	//-------------------------------------------------------------
	// Money parameter setting
	//--------------------------------------------------------------

	function money()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$this->common_header('domoney', 'Ǯϵͳ趨', '̳ýǮϵͳ,Ϸ,̳Ǯϵͳ,ÿĿ,<br />˵:ԱõĽǮͱ趨й,ÿƪ3,ÿƪظ1,ôһǮΪ3̳,һƪõĽǮΪ3+1*3=12,һƪظõĽǮΪ1*3=3,Դ');

		//-----------------------------------------------------------------------------------------------------------

		$ADMIN->html .= $SKIN->add_td_basic( 'Ǯϵͳ趨', 'left', 'catrow2' );

		//-----------------------------------------------------------------------------------------------------------

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ýǮϵͳ?</b>" ,
										  $SKIN->form_yes_no( "enable_money_system", $INFO['enable_money_system'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>(%)</b><br />ʹ" ,
                                                                                   $SKIN->form_input( "interest_per_day", $INFO['interest_per_day'] ) 
                                                                 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿעԱ</b>" ,
										  $SKIN->form_input( "money_register", $INFO['money_register'] )
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b></b>" ,
										  $SKIN->form_input( "money_per_topic", $INFO['money_per_topic'] )
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ظ</b>" ,
										  $SKIN->form_input( "money_per_post", $INFO['money_per_post'] )
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͶƱ</b>" ,
										  $SKIN->form_input( "money_per_poll", $INFO['money_per_poll'] )
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͶƱ</b>" ,
										  $SKIN->form_input( "money_per_vote", $INFO['money_per_vote'] )
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ÿƪ¸</b>" ,
										  $SKIN->form_input( "money_per_kernel", $INFO['money_per_kernel'] )
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɾ¿۳</b><br />" ,
										  $SKIN->form_input( "money_per_delete", $INFO['money_per_delete'] )
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ظ</b>" ,
										  "ÿظ".$SKIN->form_simple_input( "money_reply_step", $INFO['money_reply_step'] ).",跢".$SKIN->form_simple_input( "money_reply_bounty", $INFO['money_reply_bounty'] )."Ǯ<br />".$SKIN->form_checkbox( 'money_reply_count_self', $INFO['money_reply_count_self'] )."ⷢԼظĴ"
								 )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b></b>" ,
										  "ÿ".$SKIN->form_simple_input( "money_view_step", $INFO['money_view_step'] ).",跢".$SKIN->form_simple_input( "money_view_bounty", $INFO['money_view_bounty'] )."Ǯ<br />".$SKIN->form_checkbox( 'money_view_count_self', $INFO['money_view_count_self'] )."ⷢԼĴ"
								 )      );

		$this->common_footer();


	}
//Ǯhack
        //-------------------------------------------------------------
	//
	// Save config. Does the hard work, so you don't have to.
	//
	//--------------------------------------------------------------
	
	function save_config( $new )
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$master = array();
		
		if ( is_array($new) )
		{
			if ( count($new) > 0 )
			{
				foreach( $new as $field )
				{
				
					// Handle special..
					
					if ($field == 'img_ext' or $field == 'avatar_ext' or $field == 'photo_ext')
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/[\.\s]/", "" , $HTTP_POST_VARS[ $field ] );
						$HTTP_POST_VARS[ $field ] = str_replace('|', "|", $HTTP_POST_VARS[ $field ]);
						$HTTP_POST_VARS[ $field ] = preg_replace( "/,/"     , '|', $HTTP_POST_VARS[ $field ] );
					}
					else if ($field == 'coppa_address')
					{
						$HTTP_POST_VARS[ $field ] = nl2br( $HTTP_POST_VARS[ $field ] );
					}
					
					if ( $field == 'gd_font' OR $field == 'html_dir' OR $field == 'upload_dir')
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/'/", "'", $HTTP_POST_VARS[ $field ] );
					}
					else
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/'/", "'", $HTTP_POST_VARS[ $field ] ); /*  */
					}
				
					$master[ $field ] = stripslashes($HTTP_POST_VARS[ $field ]);  
				}
				
				$ADMIN->rebuild_config($master);
			}
		}
		
		$ADMIN->save_log("̳趨ѱ");
		
		$ADMIN->done_screen("̳趨Ѹ", "̨ҳ", "act=index" );
		
		
		
	}
	//-------------------------------------------------------------
	//
	// Common header: Saves writing the same stuff out over and over
	//
	//--------------------------------------------------------------
	
	function common_header( $formcode = "", $section = "", $extra = "" )
	{
	
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$extra = $extra ? $extra."<br>" : $extra;
		
		$ADMIN->page_detail = $extra . "ȷ֮ǰ";
		$ADMIN->page_title  = "̳趨 ($section)";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , $formcode ),
												  2 => array( 'act'   , 'op'      ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "{none}"  , "40%" );
		$SKIN->td_header[] = array( "{none}"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "趨" );
		
	}

	//-------------------------------------------------------------
	//
	// Common footer: Saves writing the same stuff out over and over
	//
	//--------------------------------------------------------------
	
	function common_footer( $button="ȷ" )
	{
	
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->html .= $SKIN->end_form($button);
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}				
	
	function return_sql_no_no_cant_do_it_sorry_text()
	{
return "
<div style='line-height:150%'>
<span id='large'>޷Զȫ</span>
<br /><br />
Զȫ̫ࡣп֮ǰʹ PHP ʱжϣ
ĳЩ𻵡
<br />
ȫ൱Ḷֵ́ýһΣ
ΪĻԱʱʡܶʱ估 CPU Դ
<br />
ƽԣһͨվһСʱԼ 80,000 ƪ£൱ҵĴ̡
ʹ MySQL 4.0.12+ ʱԻ١
<br />
<br />
<strong style='color:red;font-size:14px'>ֶ</strong>
<br />
 mysql  shell (SSH / Telnet) ʹȨ˹̷ǳ򵥡û shell ʹȨ
ҪΪС
<br /><br />
<strong> 1: ʼ mysql</strong>
<br />
 shell 룺
<br />
<pre>mysql -u{your_sql_user_name} -p{your_sql_password}</pre>
<br />
 MySQL ʹƼ conf_global.php ҵ
<br />
<br />
<strong> 2: ѡϿ</strong>
<br />
 mysql 룺
<br />
<pre>use {your_database_name_here};</pre>
<br />
β˼Ϸֺš MySQL Ͽƿ conf_global.php ҵ
<br /><br />
<strong> 3: ϱ</strong>
<br />
 mysql 룺
<br />
<pre>\g alter table ibf_topics add fulltext(title);</pre>
<br />
δʹ 'ibf_' ϱƣòѯӦ
˲ѯʱӵе
<br />
<br />
<strong> 4: ϱ</strong>
<br />
 mysql 룺
<br />
<pre>\g alter table ibf_posts add fulltext(post);</pre>
<br />
δʹ 'ibf_' ϱƣòѯӦ
˲ѯʱӵеƽԣMySQL һСʱܹ 80,000 ƪ¡ʹ MySQL 4ʱ١
</div>
";
	}
}


?>
